/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.update;

import de.willuhn.jameica.plugin.Dependency;
import de.willuhn.jameica.plugin.Version;
import de.willuhn.jameica.update.PluginData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;

public class ResolverResult {
    private PluginData pluginData = null;
    private List<PluginData> resolved = new ArrayList<PluginData>();
    private List<Dependency> missing = new ArrayList<Dependency>();

    public ResolverResult(PluginData pluginData) {
        this.pluginData = pluginData;
    }

    public PluginData getPluginData() {
        return this.pluginData;
    }

    public List<PluginData> getResolved() {
        return this.resolved;
    }

    public List<Dependency> getMissing() {
        return this.missing;
    }

    public void merge(ResolverResult merge) {
        for (PluginData p : merge.getResolved()) {
            this.mergeResolved(p);
        }
        for (Dependency dep : merge.getMissing()) {
            this.mergeMissing(dep);
        }
    }

    private void mergeResolved(PluginData d) {
        for (int i = 0; i < this.resolved.size(); ++i) {
            PluginData our = this.resolved.get(i);
            if (!ObjectUtils.equals((Object)our.getName(), (Object)d.getName())) continue;
            if (d.getAvailableVersion().compareTo(our.getAvailableVersion()) > 0) {
                this.resolved.set(i, d);
            }
            return;
        }
        this.resolved.add(d);
    }

    private void mergeMissing(Dependency d) {
        Version v = new Version(d.getVersion());
        for (int i = 0; i < this.missing.size(); ++i) {
            Dependency our = this.missing.get(i);
            if (!ObjectUtils.equals((Object)our.getName(), (Object)d.getName())) continue;
            if (v.compareTo(new Version(our.getVersion())) > 0) {
                this.missing.set(i, d);
            }
            return;
        }
        this.missing.add(d);
    }
}

